/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class RenderUtils {
    public static final int MAX_COLOR_INT_VALUE = 255;

    public static int asInt(float value) {
        return MathHelper.func_76123_f((float)(value * 255.0f));
    }

    public static float asFloat(int value) {
        return (float)value / 255.0f;
    }

    public static float red(int color) {
        return (float)RenderUtils.red_i(color) / 255.0f;
    }

    public static int red_i(int color) {
        return color >> 16 & 0xFF;
    }

    public static float green(int color) {
        return (float)RenderUtils.green_i(color) / 255.0f;
    }

    public static int green_i(int color) {
        return color >> 8 & 0xFF;
    }

    public static float blue(int color) {
        return (float)RenderUtils.blue_i(color) / 255.0f;
    }

    public static int blue_i(int color) {
        return color & 0xFF;
    }

    public static float alpha(int color) {
        return (float)RenderUtils.alpha_i(color) / 255.0f;
    }

    public static int alpha_i(int color) {
        return color >> 24 & 0xFF;
    }

    public static int combine4i(int red, int green, int blue, int alpha) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int combine4f(float red, float green, float blue, float alpha) {
        return RenderUtils.combine4i(RenderUtils.asInt(red), RenderUtils.asInt(green), RenderUtils.asInt(blue), RenderUtils.asInt(alpha));
    }

    public static int combine3i(int red, int green, int blue) {
        return RenderUtils.combine4i(red, green, blue, 255);
    }

    public static int darken(int rgb, float factor) {
        int red = (int)((float)RenderUtils.red_i(rgb) * factor);
        int green = (int)((float)RenderUtils.green_i(rgb) * factor);
        int blue = (int)((float)RenderUtils.blue_i(rgb) * factor);
        return red << 16 | green << 8 | blue;
    }

    public static int combine3f(float red, float green, float blue) {
        return RenderUtils.combine4f(red, green, blue, 1.0f);
    }

    public static int multiplyRGB(int color, double multiplier) {
        int red = (int)((double)RenderUtils.red_i(color) * multiplier);
        int green = (int)((double)RenderUtils.green_i(color) * multiplier);
        int blue = (int)((double)RenderUtils.blue_i(color) * multiplier);
        int alpha = RenderUtils.alpha_i(color);
        return RenderUtils.combine4i(red, green, blue, alpha);
    }

    public static int parseColor(String input) {
        try {
            long color = Long.decode(input);
            return (int)color;
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static void fillSolid(IVertexBuilder builder, Matrix4f pose, float x1, float y1, float x2, float y2, int color) {
        int a = RenderUtils.alpha_i(color);
        int r = RenderUtils.red_i(color);
        int g = RenderUtils.green_i(color);
        int b = RenderUtils.blue_i(color);
        builder.func_227888_a_(pose, x1, y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(pose, x1, y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(pose, x2, y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(pose, x2, y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public static void fillGradient(IVertexBuilder builder, Matrix4f pose, int x1, int y1, int x2, int y2, int depth, int color1, int color2) {
        int a1 = RenderUtils.alpha_i(color1);
        int a2 = RenderUtils.alpha_i(color2);
        int r1 = RenderUtils.red_i(color1);
        int r2 = RenderUtils.red_i(color2);
        int g1 = RenderUtils.green_i(color1);
        int g2 = RenderUtils.green_i(color2);
        int b1 = RenderUtils.blue_i(color1);
        int b2 = RenderUtils.blue_i(color2);
        builder.func_227888_a_(pose, (float)x1, (float)y2, (float)depth).func_225586_a_(r2, g2, b2, a2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y2, (float)depth).func_225586_a_(r2, g2, b2, a2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y1, (float)depth).func_225586_a_(r1, g1, b1, a1).func_181675_d();
        builder.func_227888_a_(pose, (float)x1, (float)y1, (float)depth).func_225586_a_(r1, g1, b1, a1).func_181675_d();
    }

    public static void drawLine(Matrix4f pose, int x1, int y1, int x2, int y2, int color) {
        RenderUtils.drawLine(pose, x1, y1, x2, y2, color, color);
    }

    public static void drawLine(Matrix4f pose, float x1, float y1, float x2, float y2, int color1, int color2) {
        int a1 = RenderUtils.alpha_i(color1);
        int a2 = RenderUtils.alpha_i(color2);
        int r1 = RenderUtils.red_i(color1);
        int r2 = RenderUtils.red_i(color2);
        int g1 = RenderUtils.green_i(color1);
        int g2 = RenderUtils.green_i(color2);
        int b1 = RenderUtils.blue_i(color1);
        int b2 = RenderUtils.blue_i(color2);
        RenderUtils.setupColorRenderState();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        builder.func_227888_a_(pose, x1, y1, 0.0f).func_225586_a_(r1, g1, b1, a1).func_181675_d();
        builder.func_227888_a_(pose, x2, y2, 0.0f).func_225586_a_(r2, g2, b2, a2).func_181675_d();
        tessellator.func_78381_a();
        RenderUtils.resetColorRenderState();
    }

    public static void drawSolid(Matrix4f pose, int x1, int y1, int x2, int y2, int color) {
        RenderUtils.drawSolid(pose, x1, y1, x2, y2, 0, color);
    }

    public static void drawSolid(Matrix4f pose, int x1, int y1, int x2, int y2, int depth, int color) {
        RenderUtils.drawGradient(pose, x1, y1, x2, y2, depth, color, color);
    }

    public static void drawGradient(Matrix4f pose, int x1, int y1, int x2, int y2, int color1, int color2) {
        RenderUtils.drawGradient(pose, x1, y1, x2, y2, 0, color1, color2);
    }

    public static void drawGradient(Matrix4f pose, int x1, int y1, int x2, int y2, int depth, int color1, int color2) {
        RenderUtils.setupColorRenderState();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderUtils.fillGradient((IVertexBuilder)builder, pose, x1, y1, x2, y2, depth, color1, color2);
        tessellator.func_78381_a();
        RenderUtils.resetColorRenderState();
    }

    public static void drawTex(Matrix4f pose, int x1, int y1, int x2, int y2) {
        RenderUtils.drawTex(pose, x1, y1, x2, y2, 0);
    }

    public static void drawTex(Matrix4f pose, int x1, int y1, int x2, int y2, int depth) {
        RenderUtils.drawTex(pose, x1, y1, x2, y2, depth, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawTex(Matrix4f pose, int x1, int y1, int x2, int y2, float u1, float v1, float u2, float v2) {
        RenderUtils.drawTex(pose, x1, y1, x2, y2, 0, u1, v1, u2, v2);
    }

    public static void drawTex(Matrix4f pose, int x1, int y1, int x2, int y2, int depth, float u1, float v1, float u2, float v2) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_227888_a_(pose, (float)x1, (float)y2, (float)depth).func_225583_a_(u1, v2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y2, (float)depth).func_225583_a_(u2, v2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y1, (float)depth).func_225583_a_(u2, v1).func_181675_d();
        builder.func_227888_a_(pose, (float)x1, (float)y1, (float)depth).func_225583_a_(u1, v1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
    }

    public static void drawColoredTex(Matrix4f pose, int x1, int y1, int x2, int y2, int color) {
        RenderUtils.drawColoredTex(pose, x1, y1, x2, y2, color, color);
    }

    public static void drawColoredTex(Matrix4f pose, int x1, int y1, int x2, int y2, int color1, int color2) {
        RenderUtils.drawColoredTex(pose, x1, y1, x2, y2, 0, 0.0f, 0.0f, 1.0f, 1.0f, color1, color2);
    }

    public static void drawColoredTex(Matrix4f pose, int x1, int y1, int x2, int y2, int depth, float u1, float v1, float u2, float v2, int color1, int color2) {
        int a1 = RenderUtils.alpha_i(color1);
        int a2 = RenderUtils.alpha_i(color2);
        int r1 = RenderUtils.red_i(color1);
        int r2 = RenderUtils.red_i(color2);
        int g1 = RenderUtils.green_i(color1);
        int g2 = RenderUtils.green_i(color2);
        int b1 = RenderUtils.blue_i(color1);
        int b2 = RenderUtils.blue_i(color2);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        builder.func_227888_a_(pose, (float)x1, (float)y2, (float)depth).func_225586_a_(r2, g2, b2, a2).func_225583_a_(u1, v2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y2, (float)depth).func_225586_a_(r2, g2, b2, a2).func_225583_a_(u2, v2).func_181675_d();
        builder.func_227888_a_(pose, (float)x2, (float)y1, (float)depth).func_225586_a_(r1, g1, b1, a1).func_225583_a_(u2, v1).func_181675_d();
        builder.func_227888_a_(pose, (float)x1, (float)y1, (float)depth).func_225586_a_(r1, g1, b1, a1).func_225583_a_(u1, v1).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableBlend();
    }

    public static void setupColorRenderState() {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
    }

    public static void resetColorRenderState() {
        RenderSystem.shadeModel((int)7424);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawSolid(Matrix4f pose, float x1, float y1, float x2, float y2, int color) {
        int a = RenderUtils.alpha_i(color);
        int r = RenderUtils.red_i(color);
        int g = RenderUtils.green_i(color);
        int b = RenderUtils.blue_i(color);
        RenderUtils.setupColorRenderState();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        builder.func_227888_a_(pose, x1, y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(pose, x2, y2, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(pose, x2, y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        builder.func_227888_a_(pose, x1, y1, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        tessellator.func_78381_a();
        RenderUtils.resetColorRenderState();
    }

    public static void drawBorder(Matrix4f pose, float x1, float y1, float width, float height, float thickness, int color) {
        float x2 = x1 + width;
        float y2 = y1 + height;
        RenderUtils.setupColorRenderState();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        RenderUtils.fillSolid((IVertexBuilder)builder, pose, x1, y1, x2, y1 + thickness, color);
        RenderUtils.fillSolid((IVertexBuilder)builder, pose, x1, y2 - thickness, x2, y2, color);
        RenderUtils.fillSolid((IVertexBuilder)builder, pose, x1, y1, x1 + thickness, y2, color);
        RenderUtils.fillSolid((IVertexBuilder)builder, pose, x2 - thickness, y1, x2, y2, color);
        tessellator.func_78381_a();
        RenderUtils.resetColorRenderState();
    }

    public static boolean hasGraphicsMode(GraphicsFanciness fanciness) {
        int requireId;
        GameSettings settings = Minecraft.func_71410_x().field_71474_y;
        int id = settings.field_238330_f_.func_238162_a_();
        return id >= (requireId = fanciness.func_238162_a_());
    }

    public static void drawCenteredText(MatrixStack stack, ITextComponent component, FontRenderer renderer, Widget widget, int color) {
        float x = RenderUtils.getHorizontalCenter(component, renderer, widget);
        float y = RenderUtils.getVerticalCenter(renderer, widget);
        renderer.func_243248_b(stack, component, x, y, color);
    }

    public static void drawCenteredShadowText(MatrixStack stack, ITextComponent component, FontRenderer renderer, Widget widget, int color) {
        float x = RenderUtils.getHorizontalCenter(component, renderer, widget);
        float y = RenderUtils.getVerticalCenter(renderer, widget);
        renderer.func_243246_a(stack, component, x, y, color);
    }

    public static float getHorizontalCenter(ITextComponent component, FontRenderer renderer, Widget widget) {
        return (float)widget.field_230690_l_ + (float)(widget.func_230998_h_() - renderer.func_238414_a_((ITextProperties)component)) / 2.0f;
    }

    public static float getVerticalCenter(FontRenderer renderer, Widget widget) {
        float f = widget.field_230691_m_;
        int n = widget.func_238483_d_();
        renderer.getClass();
        return f + (float)(n - 9) / 2.0f;
    }
}

